﻿var qualityControl = {
    context: $(".v-qualityControl"),
    datatable: null,
    refreshDataTable: function () {
        qualityControl.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-qualityControlTable", qualityControl.context).a4datatable({
            advancedFilter: true,
            stateKey: "QualityControl",
            ajaxAction: a4.getSurveyAction("GetAudioRecordings", "Offline"),
            columns: [
                { "Name": "FileId", "Title": resources.RecordingId },
                { "Name": "VariableName", "Title": resources.VariableName },
                { "Name": "RespondentId", "Title": resources.RespondentId },
                { "Name": "InterviewerId", "Title": resources.UserId },
                { "Name": "InterviewerUserName", "Title": resources.UserName },
                //{ "Name": "FileName", "Title": resources.FileName },
                { "Name": "FileSize", "Title": resources.Size, "Data": "FileSizeKB" },
                { "Name": "AudioLength", "Title": resources.Duration, "Data": "AudioLengthFormatted" },
                { "Name": "CreationDate", "Title": resources.Date, "Type": "datetime" },
            ],
            localizableTexts: { "Search": resources.SearchRecordingFiles },
            toolBarItems: [
                { "Action": "download", "Label": resources.Download },
                { "Action": "delete", "Label": resources.Delete }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].FileId);
                }

                switch (action) {
                    case "download":
                        qualityControl.download(ids);
                        break;
                    case "delete":
                        qualityControl.deleteItems(ids);
                        break;
                };
            },
            contextMenuItems: [
                { "Action": "download", "Label": resources.Download},
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "download":
                        qualityControl.download(row.FileId);
                        break;
                    case "delete":
                        qualityControl.deleteItems(row.FileId);
                        break;
                }
            }
        });
    },
    bindEvents: function () {

    },
    download: function (items) {
        window.location = a4.getSurveyAction("DownloadAudioFiles", "Offline", { itemIds: items });
    },
    deleteItems: function (items) {
        var res = items.length > 1 ? confirmDeleteMultipleResources : confirmDeleteResources;
        var itemLabel = "";
        var itemsCount = items.length;

        if (itemsCount === undefined) {
            itemsCount = 1;
            itemLabel = items;
        }

        if (itemsCount == 1) {
            res = confirmDeleteResources;
        }

        modalDialog.showConfirmDialog(res, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteAudioRecordings", "Offline"), { itemIds: items },
            function (result) {
                qualityControl.refreshDataTable();
            });
        }, 250, 500, true, { "count": itemsCount, "audio": itemLabel });
    },
}

$(document).ready(function () {
    if (qualityControl.context.length > 0) {
        qualityControl.initializeDataTable();
        qualityControl.bindEvents();
    }
});


